/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm;

import ibm.nways.jdm.CompoundStatus;
import ibm.nways.jdm.CompoundStatusManager;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.Status;
import ibm.nways.jdm.StatusType;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class CompStatusDefault
extends CompoundStatusManager {
    protected static float[] defaultSevs;
    protected float[] severities = new float[defaultSevs.length];
    private int[] count;
    private static final String myBundleName = "ibm.nways.jdm.CompStatusDefaultResources";
    private static final I18NString AllSame;
    private static final I18NString MaxNormal;
    private static final I18NString MaxMarginal;
    private static final I18NString OneCritical;
    private static final I18NString TwoCritical;
    private static final I18NString MixedBag;
    private static final I18NString NoDependents;

    public CompStatusDefault() {
        this.setToDefaultSeverities();
        this.count = new int[StatusType.NumDefined];
    }

    public String getLabel(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(myBundleName);
        return resourceBundle.getString("policyLabel");
    }

    public void setToDefaultSeverities() {
        int n = 0;
        while (n < defaultSevs.length) {
            this.severities[n] = defaultSevs[n];
            ++n;
        }
    }

    public StatusType compute(CompoundStatus compoundStatus) {
        StatusType statusType = compoundStatus.getStatusType();
        Vector vector = compoundStatus.getDependents();
        int n = vector.size();
        if (n == 0) {
            statusType = StatusType.UNKNOWN;
            compoundStatus.setExplanation(NoDependents);
            return statusType;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        int n2 = 0;
        Status status = null;
        int n3 = 0;
        while (n3 < StatusType.NumDefined) {
            this.count[n3] = 0;
            ++n3;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            status = (Status)enumeration.nextElement();
            int n4 = status.getStatusType().toInt();
            float f3 = this.severities[n4];
            int n5 = n4;
            this.count[n5] = this.count[n5] + 1;
            if (!(f3 > 0.0f)) continue;
            if (f < f3) {
                f = f3;
            }
            f2 += f3;
            ++n2;
        }
        if (n2 > 0) {
            f2 /= (float)n2;
        }
        n3 = 0;
        boolean bl = false;
        while (n3 < StatusType.NumDefined) {
            if (this.count[n3] == n) {
                bl = true;
                break;
            }
            ++n3;
        }
        if (bl) {
            statusType = status != null ? status.getStatusType() : StatusType.UNKNOWN;
            compoundStatus.setExplanation(AllSame);
        } else if (this.count[StatusType.NORMAL.toInt()] >= 1 && f == this.severities[StatusType.NORMAL.toInt()]) {
            statusType = StatusType.NORMAL;
            compoundStatus.setExplanation(MaxNormal);
        } else if (this.count[StatusType.MARGINAL.toInt()] >= 1 && f == this.severities[StatusType.MARGINAL.toInt()]) {
            statusType = StatusType.MARGINAL;
            compoundStatus.setExplanation(MaxMarginal);
        } else if (f == this.severities[StatusType.CRITICAL.toInt()]) {
            if (this.count[StatusType.CRITICAL.toInt()] == 1 && n2 > 1) {
                statusType = StatusType.MARGINAL;
                compoundStatus.setExplanation(OneCritical);
            } else {
                compoundStatus.setExplanation(TwoCritical);
                statusType = StatusType.CRITICAL;
            }
        } else {
            compoundStatus.setExplanation(MixedBag);
            statusType = StatusType.UNKNOWN;
        }
        return statusType;
    }

    protected void dumpDependents(CompoundStatus compoundStatus) {
        Vector vector = compoundStatus.getDependents();
        System.out.print("Compound stat deps: ");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Status status = (Status)enumeration.nextElement();
            System.out.print(String.valueOf(status.getStatusType().toString()) + " ");
        }
        System.out.println();
    }

    static {
        AllSame = new I18NString(myBundleName, "AllSame");
        MaxNormal = new I18NString(myBundleName, "MaxNormal");
        MaxMarginal = new I18NString(myBundleName, "MaxMarginal");
        OneCritical = new I18NString(myBundleName, "OneCritical");
        TwoCritical = new I18NString(myBundleName, "TwoCritical");
        MixedBag = new I18NString(myBundleName, "MixedBag");
        NoDependents = new I18NString(myBundleName, "NoDependents");
        defaultSevs = new float[StatusType.NumDefined];
        CompStatusDefault.defaultSevs[StatusType.UNKNOWN.toInt()] = 0.0f;
        CompStatusDefault.defaultSevs[StatusType.NORMAL.toInt()] = 1.0f;
        CompStatusDefault.defaultSevs[StatusType.MARGINAL.toInt()] = 2.0f;
        CompStatusDefault.defaultSevs[StatusType.CRITICAL.toInt()] = 3.0f;
        CompStatusDefault.defaultSevs[StatusType.ADMIN_DISABLED.toInt()] = 0.0f;
        CompStatusDefault.defaultSevs[StatusType.NONMEMBER.toInt()] = 0.0f;
        CompStatusDefault.defaultSevs[StatusType.UNMANAGED.toInt()] = 0.0f;
        CompStatusDefault.defaultSevs[StatusType.ACKNOWLEDGED.toInt()] = 0.0f;
        CompStatusDefault.defaultSevs[StatusType.USER_1.toInt()] = 0.0f;
        CompStatusDefault.defaultSevs[StatusType.USER_2.toInt()] = 0.0f;
    }
}

